#!/sbin/sh

uninstall_package() {
    addToLog "- uninstall_addon=$uninstall_addon" "$package_title"
    # Remove the files when we're uninstalling NiKGapps
    for i in $file_list; do
        uninstall_file "$i" "$package_title"
    done
    if [ "$uninstall_addon" = "1" ]; then
      # Removing the addon.sh sh so it doesn't get backed up and restored
      for i in $(find /system/addon.d -iname "*$package_title.sh" 2>/dev/null;); do
        if [ -f "$i" ]; then
          addToLog "- Removing $i" "$package_title"
          rm -rf "$i"
        fi
      done
    fi
    # Removing the updates and residue
    if [ -n "$2" ]; then
        for i in $(find /data -iname "*$2*" 2>/dev/null); do
            if [ -e "$i" ] || [ -d "$1" ]; then
                addToLog "- contents matching $2 found at $i"
                rm -rf "$i"
            fi
        done
    fi
}

# Initialize the variables
uninstall_addon=$1
clean_flash_only="false"
title="DeviceIntelligenceNetworkPrebuilt-U.32_V.7_playstore_astrea_20240725.00_RC01"
package_title="PrivateComputeServices"
package_name="com.google.android.as.oss"

file_list="
___priv-app___DeviceIntelligenceNetworkPrebuilt-U.32_V.7_playstore_astrea_20240725.00_RC01/DeviceIntelligenceNetworkPrebuilt-U.32_V.7_playstore_astrea_20240725.00_RC01.apk
___etc___permissions/com.google.android.as.oss.xml
"

uninstall_package
